/*
 * Decompiled with CFR 0.152.
 */
package carpet.script;

import carpet.CarpetSettings;
import carpet.script.CarpetScriptServer;
import carpet.script.Context;
import carpet.script.Fluff;
import carpet.script.LazyValue;
import carpet.script.Module;
import carpet.script.Tokenizer;
import carpet.script.exception.BreakStatement;
import carpet.script.exception.ContinueStatement;
import carpet.script.exception.ExitStatement;
import carpet.script.exception.ExpressionException;
import carpet.script.exception.IntegrityException;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ResolvedException;
import carpet.script.exception.ReturnStatement;
import carpet.script.language.Arithmetic;
import carpet.script.language.ControlFlow;
import carpet.script.language.DataStructures;
import carpet.script.language.Functions;
import carpet.script.language.Loops;
import carpet.script.language.Operators;
import carpet.script.language.Sys;
import carpet.script.language.Threading;
import carpet.script.value.FunctionValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class Expression {
    private String expression;
    private boolean allowNewlineSubstitutions = true;
    private boolean allowComments = false;
    public Module module = null;
    private LazyValue ast = null;
    private final Map<String, Fluff.ILazyOperator> operators = new Object2ObjectOpenHashMap();
    private final Map<String, Fluff.ILazyFunction> functions = new Object2ObjectOpenHashMap();
    private final Map<String, String> functionalEquivalence = new Object2ObjectOpenHashMap();
    private final Map<String, Value> constants = Map.of("euler", Arithmetic.euler, "pi", Arithmetic.PI, "null", Value.NULL, "true", Value.TRUE, "false", Value.FALSE);
    public static final Expression none = new Expression("null");

    String getCodeString() {
        return this.expression;
    }

    public String getModuleName() {
        return this.module == null ? "system chat" : this.module.name();
    }

    public void asATextSource() {
        this.allowNewlineSubstitutions = false;
        this.allowComments = true;
    }

    public void asAModule(Module mi) {
        this.module = mi;
    }

    public boolean isAnOperator(String opname) {
        return this.operators.containsKey(opname) || this.operators.containsKey(opname + "u");
    }

    public Set<String> getFunctionNames() {
        return this.functions.keySet();
    }

    public void addFunctionalEquivalence(String operator, String function) {
        assert (this.operators.containsKey(operator));
        assert (this.functions.containsKey(function));
        this.functionalEquivalence.put(operator, function);
    }

    protected Value getConstantFor(String surface) {
        return this.constants.get(surface);
    }

    public List<String> getExpressionSnippet(Tokenizer.Token token) {
        String code = this.getCodeString();
        ArrayList<String> output = new ArrayList<String>(Expression.getExpressionSnippetLeftContext(token, code, 1));
        List<String> context = Expression.getExpressionSnippetContext(token, code);
        output.add(context.get(0) + " HERE>> " + context.get(1));
        output.addAll(Expression.getExpressionSnippetRightContext(token, code, 1));
        return output;
    }

    private static List<String> getExpressionSnippetLeftContext(Tokenizer.Token token, String expr, int contextsize) {
        ArrayList<String> output = new ArrayList<String>();
        String[] lines = expr.split("\n");
        if (lines.length == 1) {
            return output;
        }
        for (int lno = token.lineno - 1; lno >= 0 && output.size() < contextsize; --lno) {
            output.add(lines[lno]);
        }
        Collections.reverse(output);
        return output;
    }

    private static List<String> getExpressionSnippetContext(Tokenizer.Token token, String expr) {
        ArrayList<String> output = new ArrayList<String>();
        String[] lines = expr.split("\n");
        if (lines.length > 1) {
            output.add(lines[token.lineno].substring(0, token.linepos));
            output.add(lines[token.lineno].substring(token.linepos));
        } else {
            output.add(expr.substring(Math.max(0, token.pos - 40), token.pos));
            output.add(expr.substring(token.pos, Math.min(token.pos + 1 + 40, expr.length())));
        }
        return output;
    }

    private static List<String> getExpressionSnippetRightContext(Tokenizer.Token token, String expr, int contextsize) {
        ArrayList<String> output = new ArrayList<String>();
        String[] lines = expr.split("\n");
        if (lines.length == 1) {
            return output;
        }
        for (int lno = token.lineno + 1; lno < lines.length && output.size() < contextsize; ++lno) {
            output.add(lines[lno]);
        }
        return output;
    }

    public void addLazyUnaryOperator(String surface, int precedence, boolean leftAssoc, final boolean pure, final Function<Context.Type, Context.Type> staticTyper, final Fluff.TriFunction<Context, Context.Type, LazyValue, LazyValue> lazyfun) {
        this.operators.put(surface + "u", new Fluff.AbstractLazyOperator(precedence, leftAssoc){

            @Override
            public boolean pure() {
                return pure;
            }

            @Override
            public boolean transitive() {
                return false;
            }

            @Override
            public Context.Type staticType(Context.Type outerType) {
                return (Context.Type)((Object)staticTyper.apply(outerType));
            }

            @Override
            public LazyValue lazyEval(Context c, Context.Type t, Expression e, Tokenizer.Token token, LazyValue v, LazyValue v2) {
                try {
                    return (LazyValue)lazyfun.apply(c, t, v);
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, token);
                }
            }
        });
    }

    public void addLazyBinaryOperatorWithDelegation(String surface, int precedence, boolean leftAssoc, final boolean pure, final Fluff.SexFunction<Context, Context.Type, Expression, Tokenizer.Token, LazyValue, LazyValue, LazyValue> lazyfun) {
        this.operators.put(surface, new Fluff.AbstractLazyOperator(precedence, leftAssoc){

            @Override
            public boolean pure() {
                return pure;
            }

            @Override
            public boolean transitive() {
                return false;
            }

            @Override
            public LazyValue lazyEval(Context c, Context.Type type, Expression e, Tokenizer.Token t, LazyValue v1, LazyValue v2) {
                try {
                    return (LazyValue)lazyfun.apply(c, type, e, t, v1, v2);
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, t);
                }
            }
        });
    }

    public void addCustomFunction(String name, Fluff.ILazyFunction fun) {
        this.functions.put(name, fun);
    }

    public void addLazyFunctionWithDelegation(String name, int numpar, final boolean pure, final boolean transitive, final Fluff.QuinnFunction<Context, Context.Type, Expression, Tokenizer.Token, List<LazyValue>, LazyValue> lazyfun) {
        this.functions.put(name, new Fluff.AbstractLazyFunction(numpar, name){

            @Override
            public boolean pure() {
                return pure;
            }

            @Override
            public boolean transitive() {
                return transitive;
            }

            @Override
            public LazyValue lazyEval(Context c, Context.Type type, Expression e, Tokenizer.Token t, List<LazyValue> lv) {
                Fluff.ILazyFunction.checkInterrupts();
                try {
                    return (LazyValue)lazyfun.apply(c, type, e, t, lv);
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, t);
                }
            }
        });
    }

    public void addFunctionWithDelegation(String name, int numpar, final boolean pure, final boolean transitive, final Fluff.QuinnFunction<Context, Context.Type, Expression, Tokenizer.Token, List<Value>, Value> fun) {
        this.functions.put(name, new Fluff.AbstractLazyFunction(numpar, name){

            @Override
            public boolean pure() {
                return pure;
            }

            @Override
            public boolean transitive() {
                return transitive;
            }

            @Override
            public LazyValue lazyEval(Context c, Context.Type type, Expression e, Tokenizer.Token t, List<LazyValue> lv) {
                try {
                    Value res = (Value)fun.apply(c, type, e, t, this.unpackArgs(lv, c, Context.NONE));
                    return (cc, tt) -> res;
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, t);
                }
            }
        });
    }

    public void addLazyBinaryOperator(String surface, int precedence, boolean leftAssoc, final boolean pure, final Function<Context.Type, Context.Type> typer, final Fluff.QuadFunction<Context, Context.Type, LazyValue, LazyValue, LazyValue> lazyfun) {
        this.operators.put(surface, new Fluff.AbstractLazyOperator(precedence, leftAssoc){

            @Override
            public boolean pure() {
                return pure;
            }

            @Override
            public boolean transitive() {
                return false;
            }

            @Override
            public Context.Type staticType(Context.Type outerType) {
                return (Context.Type)((Object)typer.apply(outerType));
            }

            @Override
            public LazyValue lazyEval(Context c, Context.Type t, Expression e, Tokenizer.Token token, LazyValue v1, LazyValue v2) {
                Fluff.ILazyFunction.checkInterrupts();
                try {
                    return (LazyValue)lazyfun.apply(c, t, v1, v2);
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, token);
                }
            }
        });
    }

    public void addBinaryContextOperator(String surface, int precedence, boolean leftAssoc, final boolean pure, final boolean transitive, final Fluff.QuadFunction<Context, Context.Type, Value, Value, Value> fun) {
        this.operators.put(surface, new Fluff.AbstractLazyOperator(precedence, leftAssoc){

            @Override
            public boolean pure() {
                return pure;
            }

            @Override
            public boolean transitive() {
                return transitive;
            }

            @Override
            public LazyValue lazyEval(Context c, Context.Type t, Expression e, Tokenizer.Token token, LazyValue v1, LazyValue v2) {
                try {
                    Value ret = (Value)fun.apply(c, t, v1.evalValue(c, Context.NONE), v2.evalValue(c, Context.NONE));
                    return (cc, tt) -> ret;
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, token);
                }
            }
        });
    }

    public static RuntimeException handleCodeException(Context c, RuntimeException exc, Expression e, Tokenizer.Token token) {
        if (exc instanceof ExitStatement) {
            return exc;
        }
        if (exc instanceof IntegrityException) {
            return exc;
        }
        if (exc instanceof InternalExpressionException) {
            return ((InternalExpressionException)exc).promote(c, e, token);
        }
        if (exc instanceof ArithmeticException) {
            return new ExpressionException(c, e, token, "Your math is wrong, " + exc.getMessage());
        }
        if (exc instanceof ResolvedException) {
            return exc;
        }
        CarpetSettings.LOG.error("Unexpected exception while running Scarpet code", (Throwable)exc);
        return new ExpressionException(c, e, token, "Error while evaluating expression: " + exc);
    }

    public void addUnaryOperator(String surface, boolean leftAssoc, final Function<Value, Value> fun) {
        this.operators.put(surface + "u", new Fluff.AbstractUnaryOperator(Operators.precedence.get("unary+-!..."), leftAssoc){

            @Override
            public Value evalUnary(Value v1) {
                return (Value)fun.apply(v1);
            }
        });
    }

    public void addBinaryOperator(String surface, int precedence, boolean leftAssoc, final BiFunction<Value, Value, Value> fun) {
        this.operators.put(surface, new Fluff.AbstractOperator(precedence, leftAssoc){

            @Override
            public Value eval(Value v1, Value v2) {
                return (Value)fun.apply(v1, v2);
            }
        });
    }

    public void addUnaryFunction(String name, final Function<Value, Value> fun) {
        this.functions.put(name, new Fluff.AbstractFunction(1, name){

            @Override
            public Value eval(List<Value> parameters) {
                return (Value)fun.apply(parameters.get(0));
            }
        });
    }

    public void addImpureUnaryFunction(String name, final Function<Value, Value> fun) {
        this.functions.put(name, new Fluff.AbstractFunction(1, name){

            @Override
            public boolean pure() {
                return false;
            }

            @Override
            public Value eval(List<Value> parameters) {
                return (Value)fun.apply(parameters.get(0));
            }
        });
    }

    public void addBinaryFunction(String name, final BiFunction<Value, Value, Value> fun) {
        this.functions.put(name, new Fluff.AbstractFunction(2, name){

            @Override
            public Value eval(List<Value> parameters) {
                return (Value)fun.apply(parameters.get(0), parameters.get(1));
            }
        });
    }

    public void addFunction(String name, final Function<List<Value>, Value> fun) {
        this.functions.put(name, new Fluff.AbstractFunction(-1, name){

            @Override
            public Value eval(List<Value> parameters) {
                return (Value)fun.apply(parameters);
            }
        });
    }

    public void addImpureFunction(String name, final Function<List<Value>, Value> fun) {
        this.functions.put(name, new Fluff.AbstractFunction(-1, name){

            @Override
            public boolean pure() {
                return false;
            }

            @Override
            public Value eval(List<Value> parameters) {
                return (Value)fun.apply(parameters);
            }
        });
    }

    public void addMathematicalUnaryFunction(String name, Function<Double, Double> fun) {
        this.addUnaryFunction(name, v -> new NumericValue((Double)fun.apply(NumericValue.asNumber(v).getDouble())));
    }

    public void addMathematicalUnaryIntFunction(String name, Function<Double, Long> fun) {
        this.addUnaryFunction(name, v -> new NumericValue((Long)fun.apply(NumericValue.asNumber(v).getDouble())));
    }

    public void addMathematicalBinaryIntFunction(String name, BiFunction<Long, Long, Long> fun) {
        this.addBinaryFunction(name, (w, v) -> new NumericValue((Long)fun.apply(NumericValue.asNumber(w).getLong(), NumericValue.asNumber(v).getLong())));
    }

    public void addMathematicalBinaryFunction(String name, BiFunction<Double, Double, Double> fun) {
        this.addBinaryFunction(name, (w, v) -> new NumericValue((Double)fun.apply(NumericValue.asNumber(w).getDouble(), NumericValue.asNumber(v).getDouble())));
    }

    public void addLazyFunction(String name, int numParams, final Fluff.TriFunction<Context, Context.Type, List<LazyValue>, LazyValue> fun) {
        this.functions.put(name, new Fluff.AbstractLazyFunction(numParams, name){

            @Override
            public boolean pure() {
                return false;
            }

            @Override
            public boolean transitive() {
                return false;
            }

            @Override
            public LazyValue lazyEval(Context c, Context.Type i, Expression e, Tokenizer.Token t, List<LazyValue> lazyParams) {
                Fluff.ILazyFunction.checkInterrupts();
                if (this.numParams >= 0 && lazyParams.size() != this.numParams) {
                    String string;
                    String error = "Function '" + this.name + "' requires " + this.numParams + " arguments, got " + lazyParams.size() + ". ";
                    if (fun instanceof Fluff.UsageProvider) {
                        Fluff.UsageProvider up = (Fluff.UsageProvider)((Object)fun);
                        string = up.getUsage();
                    } else {
                        string = "";
                    }
                    throw new InternalExpressionException(error + string);
                }
                try {
                    return (LazyValue)fun.apply(c, i, lazyParams);
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, t);
                }
            }
        });
    }

    public void addLazyFunction(String name, final Fluff.TriFunction<Context, Context.Type, List<LazyValue>, LazyValue> fun) {
        this.functions.put(name, new Fluff.AbstractLazyFunction(-1, name){

            @Override
            public boolean pure() {
                return false;
            }

            @Override
            public boolean transitive() {
                return false;
            }

            @Override
            public LazyValue lazyEval(Context c, Context.Type i, Expression e, Tokenizer.Token t, List<LazyValue> lazyParams) {
                Fluff.ILazyFunction.checkInterrupts();
                try {
                    return (LazyValue)fun.apply(c, i, lazyParams);
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, t);
                }
            }
        });
    }

    public void addPureLazyFunction(String name, int num_params, final Function<Context.Type, Context.Type> typer, final Fluff.TriFunction<Context, Context.Type, List<LazyValue>, LazyValue> fun) {
        this.functions.put(name, new Fluff.AbstractLazyFunction(num_params, name){

            @Override
            public boolean pure() {
                return true;
            }

            @Override
            public boolean transitive() {
                return false;
            }

            @Override
            public Context.Type staticType(Context.Type outerType) {
                return (Context.Type)((Object)typer.apply(outerType));
            }

            @Override
            public LazyValue lazyEval(Context c, Context.Type i, Expression e, Tokenizer.Token t, List<LazyValue> lazyParams) {
                Fluff.ILazyFunction.checkInterrupts();
                try {
                    return (LazyValue)fun.apply(c, i, lazyParams);
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, t);
                }
            }
        });
    }

    public void addContextFunction(String name, int num_params, final Fluff.TriFunction<Context, Context.Type, List<Value>, Value> fun) {
        this.functions.put(name, new Fluff.AbstractLazyFunction(num_params, name){

            @Override
            public boolean pure() {
                return false;
            }

            @Override
            public boolean transitive() {
                return false;
            }

            @Override
            public LazyValue lazyEval(Context c, Context.Type i, Expression e, Tokenizer.Token t, List<LazyValue> lazyParams) {
                Fluff.ILazyFunction.checkInterrupts();
                try {
                    Value ret = (Value)fun.apply(c, i, this.unpackArgs(lazyParams, c, Context.NONE));
                    return (cc, tt) -> ret;
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, t);
                }
            }
        });
    }

    public void addTypedContextFunction(String name, int num_params, final Context.Type reqType, final Fluff.TriFunction<Context, Context.Type, List<Value>, Value> fun) {
        this.functions.put(name, new Fluff.AbstractLazyFunction(num_params, name){

            @Override
            public boolean pure() {
                return true;
            }

            @Override
            public boolean transitive() {
                return false;
            }

            @Override
            public Context.Type staticType(Context.Type outerType) {
                return reqType;
            }

            @Override
            public LazyValue lazyEval(Context c, Context.Type i, Expression e, Tokenizer.Token t, List<LazyValue> lazyParams) {
                try {
                    Value ret = (Value)fun.apply(c, i, this.unpackArgs(lazyParams, c, reqType));
                    return (cc, tt) -> ret;
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, t);
                }
            }
        });
    }

    public FunctionValue createUserDefinedFunction(Context context, String name, Expression expr, Tokenizer.Token token, List<String> arguments, String varArgs, List<String> outers, LazyValue code) {
        if (this.functions.containsKey(name)) {
            throw new ExpressionException(context, expr, token, "Function " + name + " would mask a built-in function");
        }
        HashMap<String, LazyValue> contextValues = new HashMap<String, LazyValue>();
        for (String outer : outers) {
            LazyValue lv = context.getVariable(outer);
            if (lv == null) {
                throw new InternalExpressionException("Variable " + outer + " needs to be defined in outer scope to be used as outer parameter, and cannot be global");
            }
            contextValues.put(outer, lv);
        }
        if (contextValues.isEmpty()) {
            contextValues = null;
        }
        FunctionValue result = new FunctionValue(expr, token, name, code, arguments, varArgs, contextValues);
        if (!name.equals("_")) {
            context.host.addUserDefinedFunction(context, this.module, name, result);
        }
        return result;
    }

    public void alias(final String copy, String original) {
        final Fluff.ILazyFunction originalFunction = this.functions.get(original);
        this.functions.put(copy, new Fluff.ILazyFunction(){

            @Override
            public int getNumParams() {
                return originalFunction.getNumParams();
            }

            @Override
            public boolean numParamsVaries() {
                return originalFunction.numParamsVaries();
            }

            @Override
            public boolean pure() {
                return originalFunction.pure();
            }

            @Override
            public boolean transitive() {
                return originalFunction.transitive();
            }

            @Override
            public Context.Type staticType(Context.Type outerType) {
                return originalFunction.staticType(outerType);
            }

            @Override
            public LazyValue lazyEval(Context c, Context.Type type, Expression expr, Tokenizer.Token token, List<LazyValue> lazyParams) {
                c.host.issueDeprecation(copy + "(...)");
                return originalFunction.lazyEval(c, type, expr, token, lazyParams);
            }
        });
    }

    public void setAnyVariable(Context c, String name, LazyValue lv) {
        if (name.startsWith("global_")) {
            c.host.setGlobalVariable(this.module, name, lv);
        } else {
            c.setVariable(name, lv);
        }
    }

    public LazyValue getOrSetAnyVariable(Context c, String name) {
        LazyValue var;
        if (!name.startsWith("global_") && (var = c.getVariable(name)) != null) {
            return var;
        }
        var = c.host.getGlobalVariable(this.module, name);
        if (var != null) {
            return var;
        }
        var = (_c, _t) -> _c.host.strict ? Value.UNDEF.reboundedTo(name) : Value.NULL.reboundedTo(name);
        this.setAnyVariable(c, name, var);
        return var;
    }

    public Expression(String expression) {
        this.expression = expression.stripTrailing().replaceAll("\\r\\n?", "\n").replaceAll("\\t", "   ");
        Operators.apply(this);
        ControlFlow.apply(this);
        Functions.apply(this);
        Arithmetic.apply(this);
        Sys.apply(this);
        Threading.apply(this);
        Loops.apply(this);
        DataStructures.apply(this);
    }

    private List<Tokenizer.Token> shuntingYard(Context c) {
        ArrayList<Tokenizer.Token> outputQueue = new ArrayList<Tokenizer.Token>();
        Stack<Tokenizer.Token> stack = new Stack<Tokenizer.Token>();
        Tokenizer tokenizer = new Tokenizer(c, this, this.expression, this.allowComments, this.allowNewlineSubstitutions);
        List<Tokenizer.Token> cleanedTokens = tokenizer.postProcess();
        Tokenizer.Token lastFunction = null;
        Tokenizer.Token previousToken = null;
        for (Tokenizer.Token token : cleanedTokens) {
            switch (token.type) {
                case STRINGPARAM: 
                case LITERAL: 
                case HEX_LITERAL: {
                    if (previousToken != null && (previousToken.type == Tokenizer.Token.TokenType.LITERAL || previousToken.type == Tokenizer.Token.TokenType.HEX_LITERAL || previousToken.type == Tokenizer.Token.TokenType.STRINGPARAM)) {
                        throw new ExpressionException(c, this, token, "Missing operator");
                    }
                    outputQueue.add(token);
                    break;
                }
                case VARIABLE: {
                    outputQueue.add(token);
                    break;
                }
                case FUNCTION: {
                    stack.push(token);
                    lastFunction = token;
                    break;
                }
                case COMMA: {
                    if (previousToken != null && previousToken.type == Tokenizer.Token.TokenType.OPERATOR) {
                        throw new ExpressionException(c, this, previousToken, "Missing parameter(s) for operator ");
                    }
                    while (!stack.isEmpty() && ((Tokenizer.Token)stack.peek()).type != Tokenizer.Token.TokenType.OPEN_PAREN) {
                        outputQueue.add((Tokenizer.Token)stack.pop());
                    }
                    if (!stack.isEmpty()) break;
                    if (lastFunction == null) {
                        throw new ExpressionException(c, this, token, "Unexpected comma");
                    }
                    throw new ExpressionException(c, this, lastFunction, "Parse error for function");
                }
                case OPERATOR: {
                    if (previousToken != null && (previousToken.type == Tokenizer.Token.TokenType.COMMA || previousToken.type == Tokenizer.Token.TokenType.OPEN_PAREN)) {
                        throw new ExpressionException(c, this, token, "Missing parameter(s) for operator '" + token + "'");
                    }
                    Fluff.ILazyOperator o1 = this.operators.get(token.surface);
                    if (o1 == null) {
                        throw new ExpressionException(c, this, token, "Unknown operator '" + token + "'");
                    }
                    this.shuntOperators(outputQueue, stack, o1);
                    stack.push(token);
                    break;
                }
                case UNARY_OPERATOR: {
                    if (previousToken != null && previousToken.type != Tokenizer.Token.TokenType.OPERATOR && previousToken.type != Tokenizer.Token.TokenType.COMMA && previousToken.type != Tokenizer.Token.TokenType.OPEN_PAREN) {
                        throw new ExpressionException(c, this, token, "Invalid position for unary operator " + token);
                    }
                    Fluff.ILazyOperator o1 = this.operators.get(token.surface);
                    if (o1 == null) {
                        throw new ExpressionException(c, this, token, "Unknown unary operator '" + token.surface.substring(0, token.surface.length() - 1) + "'");
                    }
                    this.shuntOperators(outputQueue, stack, o1);
                    stack.push(token);
                    break;
                }
                case OPEN_PAREN: {
                    if (previousToken != null && previousToken.type == Tokenizer.Token.TokenType.FUNCTION) {
                        outputQueue.add(token);
                    }
                    stack.push(token);
                    break;
                }
                case CLOSE_PAREN: {
                    if (previousToken != null && previousToken.type == Tokenizer.Token.TokenType.OPERATOR) {
                        throw new ExpressionException(c, this, previousToken, "Missing parameter(s) for operator " + previousToken);
                    }
                    while (!stack.isEmpty() && ((Tokenizer.Token)stack.peek()).type != Tokenizer.Token.TokenType.OPEN_PAREN) {
                        outputQueue.add((Tokenizer.Token)stack.pop());
                    }
                    if (stack.isEmpty()) {
                        throw new ExpressionException(c, this, "Mismatched parentheses");
                    }
                    stack.pop();
                    if (stack.isEmpty() || stack.peek().type != Tokenizer.Token.TokenType.FUNCTION) break;
                    outputQueue.add(stack.pop());
                    break;
                }
                case MARKER: {
                    if (!"$".equals(token.surface)) break;
                    StringBuilder sb = new StringBuilder(this.expression);
                    sb.setCharAt(token.pos, '\n');
                    this.expression = sb.toString();
                }
            }
            if (token.type == Tokenizer.Token.TokenType.MARKER) continue;
            previousToken = token;
        }
        while (!stack.isEmpty()) {
            Tokenizer.Token element = (Tokenizer.Token)stack.pop();
            if (element.type == Tokenizer.Token.TokenType.OPEN_PAREN || element.type == Tokenizer.Token.TokenType.CLOSE_PAREN) {
                throw new ExpressionException(c, this, element, "Mismatched parentheses");
            }
            outputQueue.add(element);
        }
        return outputQueue;
    }

    private void shuntOperators(List<Tokenizer.Token> outputQueue, Stack<Tokenizer.Token> stack, Fluff.ILazyOperator o1) {
        Tokenizer.Token nextToken;
        Tokenizer.Token token = nextToken = stack.isEmpty() ? null : stack.peek();
        while (nextToken != null && (nextToken.type == Tokenizer.Token.TokenType.OPERATOR || nextToken.type == Tokenizer.Token.TokenType.UNARY_OPERATOR) && (o1.isLeftAssoc() && o1.getPrecedence() <= this.operators.get(nextToken.surface).getPrecedence() || o1.getPrecedence() < this.operators.get(nextToken.surface).getPrecedence())) {
            outputQueue.add(stack.pop());
            nextToken = stack.isEmpty() ? null : stack.peek();
        }
    }

    public Value eval(Context c) {
        if (this.ast == null) {
            this.ast = this.getAST(c);
        }
        return this.evalValue(() -> this.ast, c, Context.Type.NONE);
    }

    public Value evalValue(Supplier<LazyValue> exprProvider, Context c, Context.Type expectedType) {
        try {
            return exprProvider.get().evalValue(c, expectedType);
        }
        catch (BreakStatement | ContinueStatement | ReturnStatement exc) {
            throw new ExpressionException(c, this, "Control flow functions, like continue, break or return, should only be used in loops, and functions respectively.");
        }
        catch (ExitStatement exit) {
            return exit.retval == null ? Value.NULL : exit.retval;
        }
        catch (StackOverflowError ignored) {
            throw new ExpressionException(c, this, "Your thoughts are too deep");
        }
        catch (InternalExpressionException exc) {
            throw new ExpressionException(c, this, "Your expression result is incorrect: " + exc.getMessage());
        }
        catch (ArithmeticException exc) {
            throw new ExpressionException(c, this, "The final result is incorrect: " + exc.getMessage());
        }
    }

    private ExpressionNode RPNToParseTree(List<Tokenizer.Token> tokens, Context context) {
        Stack<ExpressionNode> nodeStack = new Stack<ExpressionNode>();
        block14: for (Tokenizer.Token token : tokens) {
            switch (token.type) {
                case UNARY_OPERATOR: {
                    ExpressionNode node = (ExpressionNode)nodeStack.pop();
                    LazyValue result = (c, t) -> this.operators.get(token.surface).lazyEval(c, t, this, token, node.op, null).evalValue(c, t);
                    nodeStack.push(new ExpressionNode(result, Collections.singletonList(node), token));
                    continue block14;
                }
                case OPERATOR: {
                    ExpressionNode v1 = (ExpressionNode)nodeStack.pop();
                    ExpressionNode v2 = (ExpressionNode)nodeStack.pop();
                    LazyValue result = (c, t) -> this.operators.get(token.surface).lazyEval(c, t, this, token, v2.op, v1.op).evalValue(c, t);
                    nodeStack.push(new ExpressionNode(result, List.of(v2, v1), token));
                    continue block14;
                }
                case VARIABLE: {
                    Value constant = this.getConstantFor(token.surface);
                    if (constant != null) {
                        token.morph(Tokenizer.Token.TokenType.CONSTANT, token.surface);
                        nodeStack.push(new ExpressionNode(LazyValue.ofConstant(constant), Collections.emptyList(), token));
                        continue block14;
                    }
                    nodeStack.push(new ExpressionNode((c, t) -> this.getOrSetAnyVariable(c, token.surface).evalValue(c, t), Collections.emptyList(), token));
                    continue block14;
                }
                case FUNCTION: {
                    ArrayList<ExpressionNode> p;
                    Fluff.ILazyFunction f;
                    String name = token.surface;
                    boolean isKnown = this.functions.containsKey(name);
                    if (isKnown) {
                        f = this.functions.get(name);
                        p = new ArrayList(!f.numParamsVaries() ? f.getNumParams() : 0);
                    } else {
                        f = this.functions.get("call");
                        p = new ArrayList<ExpressionNode>();
                    }
                    while (!nodeStack.isEmpty() && nodeStack.peek() != ExpressionNode.PARAMS_START) {
                        p.add((ExpressionNode)nodeStack.pop());
                    }
                    if (!isKnown) {
                        p.add(ExpressionNode.ofConstant(new StringValue(name), token.morphedInto(Tokenizer.Token.TokenType.STRINGPARAM, token.surface)));
                        token.morph(Tokenizer.Token.TokenType.FUNCTION, "call");
                    }
                    Collections.reverse(p);
                    if (nodeStack.peek() == ExpressionNode.PARAMS_START) {
                        nodeStack.pop();
                    }
                    List params = p.stream().map(n -> n.op).collect(Collectors.toList());
                    nodeStack.push(new ExpressionNode((c, t) -> f.lazyEval(c, t, this, token, params).evalValue(c, t), p, token));
                    continue block14;
                }
                case OPEN_PAREN: {
                    nodeStack.push(ExpressionNode.PARAMS_START);
                    continue block14;
                }
                case LITERAL: {
                    NumericValue number;
                    try {
                        number = new NumericValue(token.surface);
                    }
                    catch (NumberFormatException exception) {
                        throw new ExpressionException(context, this, token, "Not a number");
                    }
                    token.morph(Tokenizer.Token.TokenType.CONSTANT, token.surface);
                    nodeStack.push(ExpressionNode.ofConstant(number, token));
                    continue block14;
                }
                case STRINGPARAM: {
                    token.morph(Tokenizer.Token.TokenType.CONSTANT, token.surface);
                    nodeStack.push(ExpressionNode.ofConstant(new StringValue(token.surface), token));
                    continue block14;
                }
                case HEX_LITERAL: {
                    NumericValue hexNumber;
                    try {
                        hexNumber = new NumericValue(new BigInteger(token.surface.substring(2), 16).longValue());
                    }
                    catch (NumberFormatException exception) {
                        throw new ExpressionException(context, this, token, "Not a number");
                    }
                    token.morph(Tokenizer.Token.TokenType.CONSTANT, token.surface);
                    nodeStack.push(ExpressionNode.ofConstant(hexNumber, token));
                    continue block14;
                }
            }
            throw new ExpressionException(context, this, token, "Unexpected token '" + token.surface + "'");
        }
        return (ExpressionNode)nodeStack.pop();
    }

    private LazyValue getAST(Context context) {
        List<Tokenizer.Token> rpn = this.shuntingYard(context);
        this.validate(context, rpn);
        ExpressionNode root = this.RPNToParseTree(rpn, context);
        if (!CarpetSettings.scriptsOptimization) {
            return root.op;
        }
        Context.ContextForErrorReporting optimizeOnlyContext = new Context.ContextForErrorReporting(context);
        if (CarpetSettings.scriptsDebugging) {
            CarpetScriptServer.LOG.info("Input code size for " + this.getModuleName() + ": " + this.treeSize(root) + " nodes, " + this.treeDepth(root) + " deep");
        }
        boolean changed = true;
        block0: while (changed) {
            boolean optimized;
            int tree_depth;
            int tree_size;
            changed = false;
            while (true) {
                tree_size = this.treeSize(root);
                tree_depth = this.treeDepth(root);
                optimized = this.compactTree(root, Context.Type.NONE, 0);
                if (!optimized) break;
                changed = true;
                if (!CarpetSettings.scriptsDebugging) continue;
                CarpetScriptServer.LOG.info("Compacted from " + tree_size + " nodes, " + tree_depth + " code depth to " + this.treeSize(root) + " nodes, " + this.treeDepth(root) + " code depth");
            }
            while (true) {
                tree_size = this.treeSize(root);
                tree_depth = this.treeDepth(root);
                optimized = this.optimizeTree(optimizeOnlyContext, root, Context.Type.NONE, 0);
                if (!optimized) continue block0;
                changed = true;
                if (!CarpetSettings.scriptsDebugging) continue;
                CarpetScriptServer.LOG.info("Optimized from " + tree_size + " nodes, " + tree_depth + " code depth to " + this.treeSize(root) + " nodes, " + this.treeDepth(root) + " code depth");
            }
        }
        return this.extractOp(optimizeOnlyContext, root, Context.Type.NONE);
    }

    private int treeSize(ExpressionNode node) {
        if (node.op instanceof LazyValue.ContextFreeLazyValue) {
            return 1;
        }
        return node.args.stream().mapToInt(this::treeSize).sum() + 1;
    }

    private int treeDepth(ExpressionNode node) {
        if (node.op instanceof LazyValue.ContextFreeLazyValue) {
            return 1;
        }
        return node.args.stream().mapToInt(this::treeDepth).max().orElse(0) + 1;
    }

    /*
     * WARNING - void declaration
     */
    private boolean compactTree(ExpressionNode node, Context.Type expectedType, int indent) {
        boolean optimized = false;
        Tokenizer.Token.TokenType token = node.token.type;
        if (!token.isFunctional()) {
            return false;
        }
        if (node.op instanceof LazyValue.Constant) {
            return false;
        }
        String symbol = node.token.surface;
        Fluff.EvalNode operation = (token == Tokenizer.Token.TokenType.FUNCTION ? this.functions : this.operators).get(symbol);
        Context.Type requestedType = operation.staticType(expectedType);
        for (ExpressionNode expressionNode : node.args) {
            if (!this.compactTree(expressionNode, requestedType, indent + 1)) continue;
            optimized = true;
        }
        if (expectedType != Context.Type.MAPDEF && symbol.equals("->") && node.args.size() == 2) {
            void var10_15;
            String rop = node.args.get((int)1).token.surface;
            Object var10_11 = null;
            if (rop.equals(";") || rop.equals("then")) {
                List<ExpressionNode> thenArgs = node.args.get((int)1).args;
                if (thenArgs.size() > 1 && thenArgs.get((int)(thenArgs.size() - 1)).token.surface.equals("return")) {
                    ExpressionNode expressionNode = thenArgs.get(thenArgs.size() - 1);
                }
            } else if (rop.equals("return")) {
                ExpressionNode expressionNode = node.args.get(1);
            }
            if (var10_15 != null) {
                if (var10_15.args.size() > 0) {
                    var10_15.op = var10_15.args.get((int)0).op;
                    var10_15.token = var10_15.args.get((int)0).token;
                    var10_15.range = var10_15.args.get((int)0).range;
                    var10_15.args = var10_15.args.get((int)0).args;
                    if (CarpetSettings.scriptsDebugging) {
                        CarpetScriptServer.LOG.info(" - Removed unnecessary tail return of " + var10_15.token.surface + " from function body at line " + (var10_15.token.lineno + 1) + ", node depth " + indent);
                    }
                } else {
                    var10_15.op = LazyValue.ofConstant(Value.NULL);
                    var10_15.token.morph(Tokenizer.Token.TokenType.CONSTANT, "");
                    var10_15.args = Collections.emptyList();
                    if (CarpetSettings.scriptsDebugging) {
                        CarpetScriptServer.LOG.info(" - Removed unnecessary tail return from function body at line " + (var10_15.token.lineno + 1) + ", node depth " + indent);
                    }
                }
            }
        }
        for (Map.Entry entry : this.functionalEquivalence.entrySet()) {
            String operator = (String)entry.getKey();
            String function = (String)entry.getValue();
            if (!symbol.equals(operator) && !symbol.equals(function) || node.args.size() <= 0) continue;
            boolean leftOptimizable = this.operators.get(operator).isLeftAssoc();
            ExpressionNode optimizedChild = node.args.get(leftOptimizable ? 0 : node.args.size() - 1);
            String type = optimizedChild.token.surface;
            if (!type.equals(operator) && !type.equals(function) || optimizedChild.op instanceof LazyValue.ContextFreeLazyValue) continue;
            optimized = true;
            ArrayList<ExpressionNode> newargs = new ArrayList<ExpressionNode>();
            if (leftOptimizable) {
                newargs.addAll(optimizedChild.args);
                for (i = 1; i < node.args.size(); ++i) {
                    newargs.add(node.args.get(i));
                }
            } else {
                for (i = 0; i < node.args.size() - 1; ++i) {
                    newargs.add(node.args.get(i));
                }
                newargs.addAll(optimizedChild.args);
            }
            if (CarpetSettings.scriptsDebugging) {
                CarpetScriptServer.LOG.info(" - " + symbol + "(" + node.args.size() + ") => " + function + "(" + newargs.size() + ") at line " + (node.token.lineno + 1) + ", node depth " + indent);
            }
            node.token.morph(Tokenizer.Token.TokenType.FUNCTION, function);
            node.args = newargs;
        }
        return optimized;
    }

    /*
     * WARNING - void declaration
     */
    private boolean optimizeTree(Context ctx, ExpressionNode node, Context.Type expectedType, int indent) {
        void var11_18;
        boolean optimized = false;
        Tokenizer.Token.TokenType token = node.token.type;
        if (!token.isFunctional()) {
            return false;
        }
        String symbol = node.token.surface;
        if (node.op instanceof LazyValue.Constant) {
            return false;
        }
        Fluff.EvalNode operation = (token == Tokenizer.Token.TokenType.FUNCTION ? this.functions : this.operators).get(symbol);
        Context.Type requestedType = operation.staticType(expectedType);
        for (ExpressionNode expressionNode : node.args) {
            if (!this.optimizeTree(ctx, expressionNode, requestedType, indent + 1)) continue;
            optimized = true;
        }
        for (ExpressionNode expressionNode : node.args) {
            if (expressionNode.token.type.isConstant() || expressionNode.op instanceof LazyValue.ContextFreeLazyValue) continue;
            return optimized;
        }
        if (!(operation.pure() || symbol.equals("->") && expectedType == Context.Type.MAPDEF)) {
            return optimized;
        }
        if (operation.pure() && symbol.equals(":") && expectedType == Context.Type.LVALUE) {
            expectedType = Context.Type.NONE;
        }
        List<LazyValue> args = new ArrayList<LazyValue>(node.args.size());
        for (ExpressionNode arg : node.args) {
            try {
                if (arg.op instanceof LazyValue.Constant) {
                    Value val = ((LazyValue.Constant)arg.op).get();
                    args.add((c, t) -> val);
                    continue;
                }
                args.add((c, t) -> arg.op.evalValue(ctx, requestedType));
            }
            catch (NullPointerException npe) {
                throw new ExpressionException(ctx, this, node.token, "Attempted to evaluate context free expression");
            }
        }
        args = Fluff.AbstractLazyFunction.lazify(Fluff.AbstractLazyFunction.unpackLazy(args, ctx, requestedType));
        if (operation instanceof Fluff.ILazyFunction) {
            Value value = ((Fluff.ILazyFunction)operation).lazyEval(ctx, expectedType, this, node.token, args).evalValue(null, expectedType);
        } else if (args.size() == 1) {
            Value value = ((Fluff.ILazyOperator)operation).lazyEval(ctx, expectedType, this, node.token, args.get(0), null).evalValue(null, expectedType);
        } else {
            Value value = ((Fluff.ILazyOperator)operation).lazyEval(ctx, expectedType, this, node.token, args.get(0), args.get(1)).evalValue(null, expectedType);
        }
        node.op = LazyValue.ofConstant((Value)var11_18);
        if (CarpetSettings.scriptsDebugging) {
            CarpetScriptServer.LOG.info(" - " + symbol + "(" + args.stream().map(a -> a.evalValue(null, requestedType).getString()).collect(Collectors.joining(", ")) + ") => " + var11_18.getString() + " at line " + (node.token.lineno + 1) + ", node depth " + indent);
        }
        return true;
    }

    private LazyValue extractOp(Context ctx, ExpressionNode node, Context.Type expectedType) {
        if (node.op instanceof LazyValue.Constant) {
            if (node.token.type.isConstant()) {
                Value value = ((LazyValue.Constant)node.op).get();
                return (c, t) -> value;
            }
            return node.op;
        }
        if (node.op instanceof LazyValue.ContextFreeLazyValue) {
            Value ret = ((LazyValue.ContextFreeLazyValue)node.op).evalType(expectedType);
            return (c, t) -> ret;
        }
        Tokenizer.Token token = node.token;
        switch (token.type) {
            case UNARY_OPERATOR: {
                Fluff.ILazyOperator op = this.operators.get(token.surface);
                Context.Type requestedType = op.staticType(expectedType);
                LazyValue arg = this.extractOp(ctx, node.args.get(0), requestedType);
                return (c, t) -> op.lazyEval(c, t, this, token, arg, null).evalValue(c, t);
            }
            case OPERATOR: {
                Fluff.ILazyOperator op = this.operators.get(token.surface);
                Context.Type requestedType = op.staticType(expectedType);
                LazyValue arg = this.extractOp(ctx, node.args.get(0), requestedType);
                LazyValue arh = this.extractOp(ctx, node.args.get(1), requestedType);
                return (c, t) -> op.lazyEval(c, t, this, token, arg, arh).evalValue(c, t);
            }
            case VARIABLE: {
                return (c, t) -> this.getOrSetAnyVariable(c, token.surface).evalValue(c, t);
            }
            case FUNCTION: {
                Fluff.ILazyFunction f = this.functions.get(token.surface);
                Context.Type requestedType = f.staticType(expectedType);
                List params = node.args.stream().map(n -> this.extractOp(ctx, (ExpressionNode)n, requestedType)).collect(Collectors.toList());
                return (c, t) -> f.lazyEval(c, t, this, token, params).evalValue(c, t);
            }
            case CONSTANT: {
                return node.op;
            }
        }
        throw new ExpressionException(ctx, this, node.token, "Unexpected token '" + node.token.type + " " + node.token.surface + "'");
    }

    private void validate(Context c, List<Tokenizer.Token> rpn) {
        Stack<Integer> stack = new Stack<Integer>();
        stack.push(0);
        block6: for (Tokenizer.Token token : rpn) {
            switch (token.type) {
                case UNARY_OPERATOR: {
                    if ((Integer)stack.peek() >= 1) continue block6;
                    throw new ExpressionException(c, this, token, "Missing parameter(s) for operator " + token);
                }
                case OPERATOR: {
                    if ((Integer)stack.peek() < 2) {
                        if (token.surface.equals(";")) {
                            throw new ExpressionException(c, this, token, "Empty expression found for ';'");
                        }
                        throw new ExpressionException(c, this, token, "Missing parameter(s) for operator " + token);
                    }
                    stack.set(stack.size() - 1, (Integer)stack.peek() - 2 + 1);
                    continue block6;
                }
                case FUNCTION: {
                    stack.pop();
                    if (stack.size() <= 0) {
                        throw new ExpressionException(c, this, token, "Too many function calls, maximum scope exceeded");
                    }
                    stack.set(stack.size() - 1, (Integer)stack.peek() + 1);
                    continue block6;
                }
                case OPEN_PAREN: {
                    stack.push(0);
                    continue block6;
                }
            }
            stack.set(stack.size() - 1, (Integer)stack.peek() + 1);
        }
        if (stack.size() > 1) {
            throw new ExpressionException(c, this, "Too many unhandled function parameter lists");
        }
        if ((Integer)stack.peek() > 1) {
            throw new ExpressionException(c, this, "Too many numbers or variables");
        }
        if ((Integer)stack.peek() < 1) {
            throw new ExpressionException(c, this, "Empty expression");
        }
    }

    public static class ExpressionNode {
        public LazyValue op;
        public List<ExpressionNode> args;
        public Tokenizer.Token token;
        public List<Tokenizer.Token> range;
        public static final ExpressionNode PARAMS_START = new ExpressionNode(null, null, Tokenizer.Token.NONE);

        public ExpressionNode(LazyValue op, List<ExpressionNode> args, Tokenizer.Token token) {
            this.op = op;
            this.args = args;
            this.token = token;
            this.range = new ArrayList<Tokenizer.Token>();
            this.range.add(token);
        }

        public static ExpressionNode ofConstant(Value val, Tokenizer.Token token) {
            return new ExpressionNode(new LazyValue.Constant(val), Collections.emptyList(), token);
        }
    }
}

